Rem
Rem $Header: rdbms/demo/rac_wrappers/racwrapper_setup.sql /main/3 2011/05/27 08:25:52 jmadduku Exp $
Rem
Rem install.sql
Rem
Rem Copyright (c) 2009, 2011, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      install.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jmadduku    02/10/11 - Grant Unlimited Tablespace priv with RESOURCE
Rem    swshekha    09/29/09 - Created
Rem

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

drop user wrapperuser cascade ;

ACCEPT users_password PROMPT 'Please enter the password for wrapperuser: '

create user wrapperuser identified by &users_password;

grant connect, resource, unlimited tablespace to wrapperuser;

grant CREATE PROCEDURE to wrapperuser;

grant execute on dbms_aq to wrapperuser
/

grant execute on dbms_aqadm to wrapperuser
/

grant create any job to wrapperuser
/

grant SELECT ANY DICTIONARY to wrapperuser;

connect wrapperuser/&users_password

CREATE TABLE shrd$_map_table (
                schema               VARCHAR2(30) NOT NULL,
                logical_qt           VARCHAR2(30) NOT NULL,
                physical_qt          VARCHAR2(30) NOT NULL,
                logical_queue        VARCHAR2(30) ,
                physical_queue       VARCHAR2(30),
                primary_inst         NUMBER,
                secondary_inst       NUMBER,
                unshrd_in_progress   NUMBER DEFAULT 0,
     CONSTRAINT map_tab_unique UNIQUE (schema, logical_queue,primary_inst));
                
CREATE TABLE shrd$_type_table (
                  schema               VARCHAR2(30) NOT NULL,
                  payload_type          VARCHAR2(30) NOT NULL,
     CONSTRAINT type_tab_pk PRIMARY KEY (schema, payload_type));

CREATE SEQUENCE qt$_name_seq
        START with 1 INCREMENT by 1 MAXVALUE 999999999999;

CREATE SEQUENCE q$_name_seq
       START with 1 INCREMENT by 1 MAXVALUE 9999999999999;

GRANT SELECT ON qt$_name_seq TO PUBLIC;
GRANT SELECT ON q$_name_seq TO PUBLIC;

 ----------------------------------------------------------------------------

  /* Callback procedure for job monitor */
  CREATE OR REPLACE PROCEDURE cbk_jobmonitor AS
    schema varchar2(30);
    jbname varchar2(30);
    prgname varchar2(30);
  BEGIN
    begin
      SELECT OWNER, JOB_NAME, PROGRAM_NAME into schema, jbname, prgname
      from all_scheduler_jobs where ENABLED = 'FALSE' and JOB_NAME like 
      'AQRWJ$%';
    exception 
      when NO_DATA_FOUND then 
      null;
    end;

    begin 
      dbms_scheduler.drop_job(schema||'.'||jbname);
    exception 
      when others then 
      null;
    end;
    begin 
      dbms_scheduler.disable(schema||'.'||prgname,force=>true); 
    exception 
      when others then 
      null; 
    end;

    begin 
      dbms_scheduler.drop_program(schema||'.'||prgname);
    exception 
      when others then 
      null; 
    end;

END cbk_jobmonitor;
/
show errors

BEGIN
     DBMS_SCHEDULER.DROP_JOB('unshard_job_monitor');
EXCEPTION when others then null;
END;
/

  /* Create a job monitor which will remove disabled jobs */
 BEGIN
        DBMS_SCHEDULER.CREATE_JOB (
               job_name => 'unshard_job_monitor'
              ,job_type => 'plsql_block'
              ,job_action => 'begin cbk_jobmonitor; end;'
              ,start_date      => SYSTIMESTAMP
              ,repeat_interval => 'freq=minutely; interval=1'
              ,end_date        => NULL
              ,enabled => TRUE
              ,comments => 'deletes stale jobs'
     );
END;
/


 /* Load dbms_aqadm_wrapper package */
 @dbmsaqadshrd
 @mtab_routines
 @prvtaqadshrd  
 @qryshard
/* disconnect wrapperuser */ 
exit
